//								EJEMPLO 37
//						Autor: Mikel Etxebarria
//			(c) Ingeniera de Microsistemas Programados S.L.
//						www.microcontroladores.com
//								Bilbao 2006
//
//El mdulo USART. Recepcin asncrona. 
//
//El mdulo USART de los dispositivos PIC16F87X incorpora el hardware necesario para implemen-
//tar comunicacin serie asncrona full-duplex o sincrona half-duplex. En este ltimo caso el
//USART se puede comportar como Master o Slave.
//
//En el ejemplo se provoca una interrupcin cada vez que se recibe un carcter va serie. El
//programa de tratamiento visualiza, sobre los leds del laboratorio conectados a la Puerta B,
//el cdigo binario del carcter recibido. Igualmente retransmite el carcter recibido, a 
//modo de ECO.
	
#include <16f876A.h>

//Ajusta los valores de la palabra de configuracin durante el ensamblaje:
//Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

#fuses NOPROTECT,NOCPD,NOLVP,NOWDT,XT

// Con estas directivas las funciones "input" y "output_bit" no reprograman
// el pin de la puerta cada vez que son utilizadas. Si no se indica el
// modo fast_io se asume por defecto standard_io el cual reprograma el pin
// siempre antes de ser utilizadas estas funciones.

#use fast_io (B)
#use fast_io (C)
#use delay(clock=4000000)

//Habilita las funciones RS232, velocidad a 9600 baudios

#use rs232(baud=9600, xmit=PIN_C6, rcv=PIN_C7)

#int_rda	//Vector de interrupcin al recibir por el UART

//Funcin de tratamiento de la interrupcin al recibir

tratamiento()
{	
	int	dato;	//Variable para almacena el dato recibido
	dato=getc();	//Lee el dato recibido
	output_b(dato);	//Lo saca por la puerta B
	putc(dato);		//Lo transmite va RS232	
}	
	
main()
{  	
	output_b(0x00);		//Borra las salidas
	set_tris_b(0x00);	//Puerta B salida
	set_tris_c(0b10111111);	//RC7/Rx entrada, RC6/Tx salida
	enable_interrupts(INT_RDA);	//Activa interrupcin en la recepcin
	enable_interrupts(global);	//Habilita interrupciones
	
	while(1)
	{	

	}
}	
